#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/Xt3Szs

vec3 col1 = vec3(0.118, 0.365, 0.467);
vec3 col2 = vec3(0.514, 0.851, 0.933);
vec3 col3 = vec3(0.957, 0.875, 0.29);
vec3 col4 = vec3(0.973, 0.663, 0.106);
vec3 col5 = vec3(0.843, 0.431, 0.176);
vec3 col6 = vec3(0.361, 0.251, 0.145);

mat2 rot(float x)
{
    return mat2(cos(x), sin(x), -sin(x), cos(x));
}

float sdBox( vec2 p, vec2 b )
{
  vec2 d = abs(p) - b;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

vec2 box(vec2 p, float r, float k, float t)
{
	vec2 q = vec2(atan(p.y, p.x) / 3.14159 * k, length(p) - r);
    q.x = (fract(q.x / k) - 0.5) * k;
    q.y = sdBox(p * rot(t), vec2(1.0));
    return q;
}

vec3 cout = vec3(0.0);

vec3 tex(vec2 p, float t, float pt)
{
    vec2 of = vec2(cos(t), sin(t)) * 0.5;
    vec2 pof = vec2(cos(pt), sin(pt)) * 0.5;
    
	vec2 c = box(p + of, 1.0, 3.0, t);
    vec2 c2 = box(p + of, 1.0, 3.0, t);
    
    float ln = 10000.0;
    
    float k = 1.0 / (1.0 + c.y * c.y * ln);
    float u = 1.0 / (1.0 + c2.y * c2.y * ln);
    
    vec2 sub = p;
    
    cout.xy = sub / 0.25;
    cout.z = 1.0;
    
    float d = 1000.0;
    vec2 q = c2;
    for (int i = 0; i < 6; ++i) {
        for (int j = 0; j < 3; ++j) {
            q.x = abs(q.x) - 0.125;
            q *= rot(3.141592 * 0.25);
        }
        q.y = abs(q.y) - 0.25;
        q *= rot(3.141592 * 0.125);
        d = min(d, sdBox(q, vec2(0.125)));
    }
    
    float r = 1.0 / (1.0 + d * d * ln);
    
    vec2 ins = box(cout.xy + pof, 1.0, 1.0, pt);
    float imask = max(sign(ins.y), 0.0);
    float omask = max(sign(-c.y), 0.0);
    float mask = imask * omask;
    r *= omask * imask;
    
    vec2 rp = p + of;
    
    vec3 tex1 = texture(iChannel0, rp).xyz;
	tex1 = vec3(dot(tex1, vec3(0.299, 0.587, 0.114)));
    tex1 *= col1;
    
    vec3 dest = mix(tex1, vec3(0.0), max(sign(d), 0.0)) * mask;
    vec3 src = mix(col3, vec3(0.0), max(sign(-d), 0.0)) * mask;
    
    vec3 fc = mix(src + dest, vec3(0.0), r);
    
    return mix(fc, col3 * 2.0, k);
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = fragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;
    
    vec3 r = normalize(vec3(uv, 1.0 - dot(uv,uv) * 0.1));
    vec3 o = vec3(0.0, 0.0, -2.0);
    vec3 n = vec3(0.0, 0.0, 1.0);
    
    float st = iTime;
    
    o.xy += vec2(cos(iTime) * sin(iTime), sin(iTime)) * 2.0;
    r.xy *= rot(st);
    n.xz *= rot(sin(iTime) * 0.3);
    n.xy *= rot(st);
    
	float t = -dot(o, n) / dot(r, n);
    t += max(sign(-t), 0.0) * -1000.0;
    vec3 w = o + r * t;
    
    float end = log(256.0);
    float zt = mod(st, end);
    float depth = 64.0 * exp(zt);
    w.xy /= depth;
    
    /* to give the appearence of linear time zooming i use exp(iTime). */
    /* the scene matches up every 4^n seconds, so i can only mod() when */
    /* exp(iTime) = some power of 4, and for this modulus i use log(4^4 = 256) */
    
    vec3 p = vec3(w.xy, 1.0);
    vec3 col = vec3(0.0);
    float pinv = 0.0;
    
    for (int i = 0; i < 10; ++i) {
        float inv = mod(floor(float(i)), 2.0) * 2.0 - 1.0;
        float t = inv * iTime / end * 3.141592;
        float pt = pinv * iTime / end * 3.141592;
    	col += tex(p.xy, t, pt) * p.z;
        p = cout;
        pinv = inv;
    }
    
    float fog = 1.0 / (1.0 + t * t * 0.01);
    
    col = mix(col6, col, fog);
    
	fragColor = vec4(sqrt(col), 1.0);
}


///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


